import javax.swing.*;
import java.awt.*;
import java.sql.*;

public class ReportFrame extends JFrame {
    public ReportFrame(String username) {
        setTitle("CME Report");
        setLayout(new GridLayout(4, 2));

        JTextField startDate = new JTextField("YYYY-MM-DD");
        JTextField endDate = new JTextField("YYYY-MM-DD");

        add(new JLabel("Start Date:"));
        add(startDate);
        add(new JLabel("End Date:"));
        add(endDate);

        JButton generateBtn = new JButton("Generate");
        add(new JLabel());
        add(generateBtn);

        JTextArea resultArea = new JTextArea(8, 30);
        add(new JScrollPane(resultArea));

        generateBtn.addActionListener(e -> {
            try (Connection conn = Database.getConnection()) {
                String sql = """
                    SELECT type, SUM(creditHours) AS total
                    FROM Courses
                    WHERE username=? AND date BETWEEN ? AND ?
                    GROUP BY type
                """;
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setString(1, username);
                ps.setString(2, startDate.getText());
                ps.setString(3, endDate.getText());
                ResultSet rs = ps.executeQuery();

                double grandTotal = 0;
                StringBuilder sb = new StringBuilder("Report for " + username + "\n\n");
                while (rs.next()) {
                    String type = rs.getString("type");
                    double total = rs.getDouble("total");
                    sb.append(String.format("%s: %.2f hours\n", type, total));
                    grandTotal += total;
                }
                sb.append("\nGrand Total: ").append(String.format("%.2f hours", grandTotal));
                resultArea.setText(sb.toString());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        });

        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }
}
