import javax.swing.*;
import java.awt.*;
import java.sql.*;

public class RegisterFrame extends JFrame {
    private final JFrame parent;

    public RegisterFrame(JFrame parent) {
        this.parent = parent;
        parent.setVisible(false);  // hide login while registering

        setTitle("Register User");
        setLayout(new GridLayout(3, 2));

        JTextField userField = new JTextField();
        JPasswordField passField = new JPasswordField();

        add(new JLabel("Username:"));
        add(userField);
        add(new JLabel("Password:"));
        add(passField);

        JButton registerBtn = new JButton("Register");
        add(new JLabel());
        add(registerBtn);

        registerBtn.addActionListener(e -> registerUser(userField.getText(), new String(passField.getPassword())));

        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }

    private void registerUser(String username, String password) {
        if (username.isBlank() || password.isBlank()) {
            JOptionPane.showMessageDialog(this, "Both fields required!");
            return;
        }

        try (Connection conn = Database.getConnection()) {
            PreparedStatement ps = conn.prepareStatement("INSERT INTO Users VALUES (?, ?)");
            ps.setString(1, username);
            ps.setString(2, password);
            ps.executeUpdate();
            JOptionPane.showMessageDialog(this, "Registration successful! You can now log in.");
            dispose();
            parent.setVisible(true); // re-show login frame
        } catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Username already exists or DB error.");
        }
    }
}
