import javax.swing.*;

public class MainMenu extends JFrame {
    private final String username;

    public MainMenu(String username) {
        this.username = username;
        setTitle("CME Tracker - " + username);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        JButton addCourseBtn = new JButton("Add Course");
        JButton reportBtn = new JButton("Generate Report");
        JButton exitBtn = new JButton("Logout");

        addCourseBtn.addActionListener(e -> new CourseEntryFrame(username));
        reportBtn.addActionListener(e -> new ReportFrame(username));
        exitBtn.addActionListener(e -> {
            dispose();
            new LoginFrame();
        });

        JPanel panel = new JPanel();
        panel.add(addCourseBtn);
        panel.add(reportBtn);
        panel.add(exitBtn);

        add(panel);
        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }
}
