import java.sql.*;

public class Database {
    private static final String URL = "jdbc:sqlite:cme.db";

    public static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(URL);
    }

    // Ensure tables exist
    static {
        try (Connection conn = getConnection(); Statement stmt = conn.createStatement()) {
            stmt.execute("CREATE TABLE IF NOT EXISTS Users (" +
                         "username TEXT PRIMARY KEY, password TEXT)");
            stmt.execute("CREATE TABLE IF NOT EXISTS Courses (" +
                         "id INTEGER PRIMARY KEY AUTOINCREMENT," +
                         "username TEXT," +
                         "date TEXT, course_name TEXT, credit_hours REAL, type TEXT)");
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
}
