import javax.swing.*;
import java.awt.*;
import java.sql.*;

public class CourseEntryFrame extends JFrame {
    public CourseEntryFrame(String username) {
        setTitle("Add CME Course");
        setLayout(new GridLayout(5, 2));

        JTextField dateField = new JTextField("YYYY-MM-DD");
        JTextField hoursField = new JTextField();
        JTextField titleField = new JTextField();
        JComboBox<String> typeBox = new JComboBox<>(new String[]{"MD", "DO", "Other"});

        add(new JLabel("Date:"));
        add(dateField);
        add(new JLabel("Credit Hours:"));
        add(hoursField);
        add(new JLabel("Course Title:"));
        add(titleField);
        add(new JLabel("Type:"));
        add(typeBox);

        JButton saveBtn = new JButton("Save");
        add(new JLabel());
        add(saveBtn);

        saveBtn.addActionListener(e -> {
            try (Connection conn = Database.getConnection()) {
                PreparedStatement ps = conn.prepareStatement(
                    "INSERT INTO Courses (username, date, creditHours, title, type) VALUES (?, ?, ?, ?, ?)"
                );
                ps.setString(1, username);
                ps.setString(2, dateField.getText());
                ps.setDouble(3, Double.parseDouble(hoursField.getText()));
                ps.setString(4, titleField.getText());
                ps.setString(5, typeBox.getSelectedItem().toString());
                ps.executeUpdate();
                JOptionPane.showMessageDialog(this, "Course Added!");
                dispose();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        });

        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }
}
